<?php
// security.php - CSRF helpers for skyrayshop panel

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

function skyrayshop_generate_csrf_token() {
    if (empty($_SESSION['csrf_token'])) {
        $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
    }
    return $_SESSION['csrf_token'];
}

function skyrayshop_check_csrf_token($token) {
    if (empty($_SESSION['csrf_token']) || empty($token)) {
        return false;
    }
    return hash_equals($_SESSION['csrf_token'], $token);
}
